﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;

public class GameManager : MonoBehaviour {

    public static GameManager instance;

    public GameObject panel;
    public GameObject cameraMovement;

    [SerializeField]
    public Button tapToStartButton, resumeButton, restartButton, menuButton;
                  

    [SerializeField]
    public Text pauseText, scoreText, bestScoreText, timertext;

    private float timer;
    public Image newHighScoreImg;

    void Awake () {
        Time.timeScale = 0f;
        MakeInstance();
        timer = Time.time;
	}
	
	void Update () {
        float t = Time.time - timer;
        timertext.text = "" + t.ToString("0000");

        if (t >= 517f) {
           PlayerMovement.instance.speed = 0f;
        }

        if (Time.time >= 5f) {
        }

        if (cameraMovement.transform.position.x >= 765f) {
            CameraScript.instance.speed = 0f;
        }
       
    }

    void MakeInstance() {
        if (instance == null) {
            instance = this;
        }
    }

    public void TapToStartGame() {
        Time.timeScale = 1f;
        tapToStartButton.gameObject.SetActive(false);
    }

    public void PauseGame() {
        Time.timeScale = 0f;
        panel.SetActive(true);
        pauseText.gameObject.SetActive(true);
        menuButton.gameObject.SetActive(true);
        restartButton.gameObject.SetActive(true);
        resumeButton.gameObject.SetActive(true);
        scoreText.text = "Coin Score : " + ScoreCount.instance.countScore;
        bestScoreText.text = "Best Score : " + Score.instance.GetHighScore();
    }

    public void ResumeGame() {
        Time.timeScale = 1f;
        panel.SetActive(false);
    }

    public void RestartGame() {
        string loadScene = SceneManager.GetActiveScene().name;
        SceneManager.LoadScene(loadScene, LoadSceneMode.Single);
    }

    public void GotoMain() {
        SceneManager.LoadScene("Main");
    }

    public void GameManagerScore(int score) {
        scoreText.text = "Coin Score : " + score;
    }

    IEnumerator DeathPanel() {
        yield return new WaitForSeconds(2.5f);
        Time.timeScale = 0f;
    }

    public void IfPlayerDied(int diedScore) {
        bestScoreText.text = "Best Score : " + ScoreCount.instance.countScore;

        if (diedScore > Score.instance.GetHighScore()) {
            Score.instance.SetHighScore(diedScore);
            newHighScoreImg.gameObject.SetActive(true);
        }
        bestScoreText.text = "Best Score : " + Score.instance.GetHighScore();
    }
}
